﻿using JmpModel.Model.DataContext;
using JmpModel.Model.Repository.BaseRepository;
using JmpModel.Model.Repository.CommonRepository;
using JmpModel.Model.Repository.ViewsRepository;
using JmpModel.Model.Respository.BaseRepository;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Storage;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.IO.Pipes;
using System.Linq;
using System.Linq.Expressions;
using System.Security.Principal;
using System.Threading.Tasks;
using System.Xml;


namespace JmpModel.Model.Repository
{
    public class UnitOfWork : IDisposable
    {
        //public static UnitOfWork Instance = new UnitOfWork(new JunmppolicesqlContext());
        private ILogger<UnitOfWork> _logger;
        public JunmppolicesqlContext DbContext { get; set; } = null;
        public List<Dictionary<string, CommonJpMessage>> messages = new List<Dictionary<string, CommonJpMessage>>();
        public UnitOfWork(JunmppolicesqlContext dbContext, ILogger<UnitOfWork> _logger)
        {
            this._logger = _logger;
            DbContext = dbContext;
            messages = new List<Dictionary<string, CommonJpMessage>>();
        }

        #region 字段
        private ApiMqttMessageRepository _ApiMqttMessageRepository = null;
        private ViewEquipmentDetailRepository _ViewEquipmentDetailRepository = null;
        private ViewStateRepository _ViewStateRepository = null;
        private BaseJpBagMapRepository _BaseJpBagMapRepository = null;
        private BagInventoryRepository _BagInventoryRepository = null;
        private MissionChildRepository _MissionChildRepository = null;
        private MissionRepository _MissionRepository = null;
        private ModelBagRepository _ModelBagRepository = null;
        private ChannelCfgRepository _ChannelCfgRepository = null;
        private BaseJpModelRepository _BaseJpModelRepository = null;
        private BaseJpBagRepository _BaseJpBagRepository = null;
        private ChannelCfgV2Repository _channelCfgV2Repository = null;
        private FixUselessDetailRepository _FixUselessDetailRepository = null;
        private CabinetRepository _CabinetRepository = null;
        private EquipmentInventoryRepository _EquipmentInventoryRepository = null;
        private EquipmentDetailRepository _EquipmentDetailRepository = null;
        private EquipmentInfoRepository _EquipmentInfoRepository = null;
        private EquipmentSizeRepository _EquipmentSizeRepository = null;
        private PurchaseOrderyRepository _PurchaseOrderyRepository = null;
        private PurchaseDetailRepository _PurchaseDetailRepository = null;
        private SupplierRepository _SupplierRepository = null;
        private OrganizationRepository _OrganizationRepository = null;
        private PolicemanRepository _PolicemanRepository = null;
        private SupplierProductRepository _SupplierProductRepository = null;
        private WarehouseRepository _WarehouseRepository = null;
        private FixReceiveApplyRepository _FixReceiveApplyRepository = null;
        private BaseJpSoftUpdateRepository _BaseJpSoftUpdateRepository = null;
        private FixReceiveApplyDetailRepository _FixReceiveApplyDetailRepository = null;
        private FixUselessRepository _FixUselessRepository = null;
        private BorrowReturnApplyRepository _BorrowReturnApplyRepository = null;
        private BorrowReturnDetailEstimateRepository _BorrowReturnDetailEstimateRepository = null;
        private BorrowReturnDetailRealityRepository _BorrowReturnDetailRealityRepository = null;
        private BorrowReturnRepository _BorrowReturnRepository = null;
        private EquipmentHistoryRepository _EquipmentHistoryRepository = null;
        private EquipmentStateRepository _EquipmentStateRepository = null;
        private LogRepository _LogRepository = null;
        private MessageRepository _MessageRepository = null;
        private TransferApplyRepository _TransferApplyRepository = null;
        private TransferDetailEstimateRepository _TransferDetailEstimateRepository = null;
        private TransferDetailRealityRepository _TransferDetailRealityRepository = null;
        private TransferRepository _TransferRepository = null;
        private ViewBorrowRepository _ViewBorrowRepository = null;
        private ViewEquipmentRepository _ViewEquipmentRepository = null;
        private ViewEquipmentTypeRepository _ViewEquipmentTypeRepository = null;
        private ViewEquipmentCountRepository _ViewEquipmentCountRepository = null;
        private ViewEquipmentLocationRepository _ViewEquipmentLocationRepository = null;
        private ViewUselessRepository _ViewUselessRepository = null;
        private ViewOutInOrderRepository _ViewOutInOrderRepository = null;
        private ViewSyPRepository _ViewSyPRepository = null;
        private ViewBfPRepository _ViewBfPRepository = null;
        private ViewWxPRepository _ViewWxPRepository = null;
        private ScrapViewRepository _ScrapViewRepository = null;
        private PurchaseEpcsRepository _PurchaseEpcsRepository = null;
        private WarehouseDevRepository _WarehouseDevRepository = null;
        private BaseJpProcessRepository _BaseJpProcessRepository = null;
        private CommonJpProcessCurrentRepository _CommonJpProcessCurrentRepository = null;
        private CommonJpProcessHistoryRepository _CommonJpProcessHistoryRepository = null;
        private CommonJpUserRepository _CommonJpUserRepository = null;
        private CommonJpUserInfoRepository _CommonJpUserInfoRepository = null;
        private UsersRoleRepository _UsersRoleRepository = null;
        private RoleRepository _RoleRepository = null;
        private BaseChargeRepository _BaseCharge = null;
        private CommonJpLogCfgRepository _CommonJpLogCfgRepository = null;
        private BorrowViewRepository _BorrowViewRepository = null;
        private BaseJpWarehouseDevHistoryRepository _BaseJpWarehouseDevHistoryRepository = null;
        private VOrderInfoRepository _VOrderInfoRepository = null;
        private ViewOrderStateRepository _ViewOrderStateRepository = null;
        private ViewAllOrderRepository _ViewAllOrderRepository = null;
        private CommonJpTempEquipmentRepository _CommonJpTempEquipmentRepository = null;
        private CommonJpTempEquipmentSupplierRepository _CommonJpTempEquipmentSupplierRepository = null;
        private BaseJpShelfInfoRepository _BaseJpShelfInfoRepository = null;
        private CommonJpInventoryDetailRepository _CommonJpInventoryDetailRepository = null;
        private CommonJpInventoryTableRepository _CommonJpInventoryTableRepository = null;
        private CabineOutInlogRepository _CabineOutInlogRepository = null;
        private CabinetWorklogRepository _CabinetWorklogRepository = null;
        private InventoryReturnApplyDetailRepository _InventoryReturnApplyDetailRepository = null;
        private InventoryReturnApplyRepository _InventoryReturnApplyRepository = null;
        private EquipmentBoxMarkRepository _EquipmentBoxMarkRepository = null;
        private CabinetPolicemanMultipleRepository _CabinetPolicemanMultipleRepository = null;
        private CommonJpPoliceShiftJobsApplyRepository _CommonJpPoliceShiftJobsApplyRepository = null;
        private CommonJpPoliceShiftJobsApplyDetailRepository _CommonJpPoliceShiftJobsApplyDetailRepository = null;
        private BaseJpTempFileRepository _BaseJpTempFileRepository = null;
        private BaseJpTempFileLogRepository _BaseJpTempFileLogRepository = null;

        #endregion

        #region 操作类属性
        public ApiMqttMessageRepository ApiMqttMessageRepository => _ApiMqttMessageRepository ?? (_ApiMqttMessageRepository = new ApiMqttMessageRepository(DbContext));
        public ViewEquipmentDetailRepository ViewEquipmentDetailRepository => _ViewEquipmentDetailRepository ?? (_ViewEquipmentDetailRepository = new ViewEquipmentDetailRepository(DbContext));
        public ViewStateRepository ViewStateRepository => _ViewStateRepository ?? (_ViewStateRepository = new ViewStateRepository(DbContext));
        public BagInventoryRepository BagInventoryRepository => _BagInventoryRepository ?? (_BagInventoryRepository = new BagInventoryRepository(DbContext));
        public BaseJpBagMapRepository BaseJpBagMapRepository => _BaseJpBagMapRepository ?? (_BaseJpBagMapRepository = new BaseJpBagMapRepository(DbContext));

        public MissionChildRepository MissionChildRepository => _MissionChildRepository ?? (_MissionChildRepository = new MissionChildRepository(DbContext));
        public MissionRepository MissionRepository => _MissionRepository ?? (_MissionRepository = new MissionRepository(DbContext));
        public ModelBagRepository ModelBagRepository => _ModelBagRepository ?? (_ModelBagRepository = new ModelBagRepository(DbContext));
        public BaseJpModelRepository BaseJpModelRepository => _BaseJpModelRepository ?? (_BaseJpModelRepository = new BaseJpModelRepository(DbContext));

        public CabinetPolicemanMultipleRepository CabinetPolicemanMultipleRepository => _CabinetPolicemanMultipleRepository ?? (_CabinetPolicemanMultipleRepository = new CabinetPolicemanMultipleRepository(DbContext));
        public BaseJpBagRepository BaseJpBagRepository => _BaseJpBagRepository ?? (_BaseJpBagRepository = new BaseJpBagRepository(DbContext));
        public CabineOutInlogRepository CabineOutInlogRepository => _CabineOutInlogRepository ?? (_CabineOutInlogRepository = new CabineOutInlogRepository(DbContext));
        public CabinetWorklogRepository CabinetWorklogRepository => _CabinetWorklogRepository ?? (_CabinetWorklogRepository = new CabinetWorklogRepository(DbContext));
        public BaseJpShelfInfoRepository BaseJpShelfInfoRepository => _BaseJpShelfInfoRepository ?? (_BaseJpShelfInfoRepository = new BaseJpShelfInfoRepository(DbContext));
        public CommonJpTempEquipmentRepository CommonJpTempEquipmentRepository => _CommonJpTempEquipmentRepository ?? (_CommonJpTempEquipmentRepository = new CommonJpTempEquipmentRepository(DbContext));
        public CommonJpTempEquipmentSupplierRepository CommonJpTempEquipmentSupplierRepository => _CommonJpTempEquipmentSupplierRepository ?? (_CommonJpTempEquipmentSupplierRepository = new CommonJpTempEquipmentSupplierRepository(DbContext));
        public ViewAllOrderRepository ViewAllOrderRepository => _ViewAllOrderRepository ?? (_ViewAllOrderRepository = new ViewAllOrderRepository(DbContext));
        public ViewOrderStateRepository ViewOrderStateRepository => _ViewOrderStateRepository ?? (_ViewOrderStateRepository = new ViewOrderStateRepository(DbContext));
        public VOrderInfoRepository VOrderInfoRepository => _VOrderInfoRepository ?? (_VOrderInfoRepository = new VOrderInfoRepository(DbContext));
        public BorrowReturnApplyRepository BorrowReturnApplyRepository => _BorrowReturnApplyRepository ?? (_BorrowReturnApplyRepository = new BorrowReturnApplyRepository(DbContext));
        public EquipmentDetailRepository EquipmentDetailRepository => _EquipmentDetailRepository ?? (_EquipmentDetailRepository = new EquipmentDetailRepository(DbContext));
        public TransferRepository TransferRepository => _TransferRepository ?? (_TransferRepository = new TransferRepository(DbContext));
        public TransferDetailRealityRepository TransferDetailRealityRepository => _TransferDetailRealityRepository ?? (_TransferDetailRealityRepository = new TransferDetailRealityRepository(DbContext));
        public TransferDetailEstimateRepository TransferDetailEstimateRepository => _TransferDetailEstimateRepository ?? (_TransferDetailEstimateRepository = new TransferDetailEstimateRepository(DbContext));
        public TransferApplyRepository TransferApplyRepository => _TransferApplyRepository ?? (_TransferApplyRepository = new TransferApplyRepository(DbContext));
        public MessageRepository MessageRepository => _MessageRepository ?? (_MessageRepository = new MessageRepository(DbContext));
        public LogRepository LogRepository => _LogRepository ?? (_LogRepository = new LogRepository(DbContext));
        public EquipmentStateRepository EquipmentStateRepository => _EquipmentStateRepository ?? (_EquipmentStateRepository = new EquipmentStateRepository(DbContext));
        public EquipmentHistoryRepository EquipmentHistoryRepository => _EquipmentHistoryRepository ?? (_EquipmentHistoryRepository = new EquipmentHistoryRepository(DbContext));
        public BorrowReturnRepository BorrowReturnRepository => _BorrowReturnRepository ?? (_BorrowReturnRepository = new BorrowReturnRepository(DbContext));
        public BorrowReturnDetailRealityRepository BorrowReturnDetailRealityRepository => _BorrowReturnDetailRealityRepository ?? (_BorrowReturnDetailRealityRepository = new BorrowReturnDetailRealityRepository(DbContext));
        public BorrowReturnDetailEstimateRepository BorrowReturnDetailEstimateRepository => _BorrowReturnDetailEstimateRepository ?? (_BorrowReturnDetailEstimateRepository = new BorrowReturnDetailEstimateRepository(DbContext));
        public CabinetRepository CabinetRepository => _CabinetRepository ?? (_CabinetRepository = new CabinetRepository(DbContext));
        public WarehouseRepository WarehouseRepository => _WarehouseRepository ?? (_WarehouseRepository = new WarehouseRepository(DbContext));
        public WarehouseDevRepository WarehouseDevRepository => _WarehouseDevRepository ?? (_WarehouseDevRepository = new WarehouseDevRepository(DbContext));
        public SupplierProductRepository SupplierProductRepository => _SupplierProductRepository ?? (_SupplierProductRepository = new SupplierProductRepository(DbContext));
        public PolicemanRepository PolicemanRepository => _PolicemanRepository ?? (_PolicemanRepository = new PolicemanRepository(DbContext));
        public OrganizationRepository OrganizationRepository => _OrganizationRepository ?? (_OrganizationRepository = new OrganizationRepository(DbContext));
        public SupplierRepository SupplierRepository => _SupplierRepository ?? (_SupplierRepository = new SupplierRepository(DbContext));
        public EquipmentInventoryRepository EquipmentInventoryRepository => _EquipmentInventoryRepository ?? (_EquipmentInventoryRepository = new EquipmentInventoryRepository(DbContext));
        public EquipmentInfoRepository EquipmentInfoRepository => _EquipmentInfoRepository ?? (_EquipmentInfoRepository = new EquipmentInfoRepository(DbContext));
        public EquipmentSizeRepository EquipmentSizeRepository => _EquipmentSizeRepository ?? (_EquipmentSizeRepository = new EquipmentSizeRepository(DbContext));
        public PurchaseOrderyRepository PurchaseOrderyRepository => _PurchaseOrderyRepository ?? (_PurchaseOrderyRepository = new PurchaseOrderyRepository(DbContext));
        public ChannelCfgRepository ChannelCfgRepository => _ChannelCfgRepository ?? (_ChannelCfgRepository = new ChannelCfgRepository(DbContext));
        public ChannelCfgV2Repository ChannelCfgV2Repository => _channelCfgV2Repository ?? (_channelCfgV2Repository = new ChannelCfgV2Repository(DbContext));
        public PurchaseDetailRepository PurchaseDetailRepository => _PurchaseDetailRepository ?? (_PurchaseDetailRepository = new PurchaseDetailRepository(DbContext));
        public PurchaseEpcsRepository PurchaseEpcsRepository => _PurchaseEpcsRepository ?? (_PurchaseEpcsRepository = new PurchaseEpcsRepository(DbContext));
        public FixReceiveApplyRepository FixReceiveApplyRepository => _FixReceiveApplyRepository ?? (_FixReceiveApplyRepository = new FixReceiveApplyRepository(DbContext));
        public BaseJpSoftUpdateRepository BaseJpSoftUpdateRepository => _BaseJpSoftUpdateRepository ?? (_BaseJpSoftUpdateRepository = new BaseJpSoftUpdateRepository(DbContext));
        public FixReceiveApplyDetailRepository FixReceiveApplyDetailRepository => _FixReceiveApplyDetailRepository ?? (_FixReceiveApplyDetailRepository = new FixReceiveApplyDetailRepository(DbContext));
        public FixUselessRepository FixUselessRepository => _FixUselessRepository ?? (_FixUselessRepository = new FixUselessRepository(DbContext));
        public ViewBorrowRepository ViewBorrowRepository => _ViewBorrowRepository ?? (_ViewBorrowRepository = new ViewBorrowRepository(DbContext));
        public ViewEquipmentRepository ViewEquipmentRepository => _ViewEquipmentRepository ?? (_ViewEquipmentRepository = new ViewEquipmentRepository(DbContext));

        public ViewEquipmentTypeRepository ViewEquipmentTypeRepository => _ViewEquipmentTypeRepository ?? (_ViewEquipmentTypeRepository = new ViewEquipmentTypeRepository(DbContext));
        public ViewEquipmentCountRepository ViewEquipmentCountRepository => _ViewEquipmentCountRepository ?? (_ViewEquipmentCountRepository = new ViewEquipmentCountRepository(DbContext));
        public ViewEquipmentLocationRepository ViewEquipmentLocationRepository => _ViewEquipmentLocationRepository ?? (_ViewEquipmentLocationRepository = new ViewEquipmentLocationRepository(DbContext));

        public ViewUselessRepository ViewUselessRepository => _ViewUselessRepository ?? (_ViewUselessRepository = new ViewUselessRepository(DbContext));
        public ViewOutInOrderRepository ViewOutInOrderRepository => _ViewOutInOrderRepository ?? (_ViewOutInOrderRepository = new ViewOutInOrderRepository(DbContext));
        public FixUselessDetailRepository FixUselessDetailRepository => _FixUselessDetailRepository ?? (_FixUselessDetailRepository = new FixUselessDetailRepository(DbContext));
        public ViewSyPRepository ViewSyPRepository => _ViewSyPRepository ?? (_ViewSyPRepository = new ViewSyPRepository(DbContext));
        public ViewBfPRepository ViewBfPRepository => _ViewBfPRepository ?? (_ViewBfPRepository = new ViewBfPRepository(DbContext));
        public ViewWxPRepository ViewWxPRepository => _ViewWxPRepository ?? (_ViewWxPRepository = new ViewWxPRepository(DbContext));
        public ScrapViewRepository ScrapViewRepository => _ScrapViewRepository ?? (_ScrapViewRepository = new ScrapViewRepository(DbContext));
        public BorrowViewRepository BorrowViewRepository => _BorrowViewRepository ?? (_BorrowViewRepository = new BorrowViewRepository(DbContext));
        public BaseJpProcessRepository BaseJpProcessRepository => _BaseJpProcessRepository ?? (_BaseJpProcessRepository = new BaseJpProcessRepository(DbContext));
        public CommonJpProcessCurrentRepository CommonJpProcessCurrentRepository => _CommonJpProcessCurrentRepository ?? (_CommonJpProcessCurrentRepository = new CommonJpProcessCurrentRepository(DbContext));
        public CommonJpProcessHistoryRepository CommonJpProcessHistoryRepository => _CommonJpProcessHistoryRepository ?? (_CommonJpProcessHistoryRepository = new CommonJpProcessHistoryRepository(DbContext));
        public CommonJpUserRepository CommonJpUserRepository => _CommonJpUserRepository ?? (_CommonJpUserRepository = new CommonJpUserRepository(DbContext));
        public CommonJpUserInfoRepository CommonJpUserInfoRepository => _CommonJpUserInfoRepository ?? (_CommonJpUserInfoRepository = new CommonJpUserInfoRepository(DbContext));
        public UsersRoleRepository UsersRoleRepository => _UsersRoleRepository ?? (_UsersRoleRepository = new UsersRoleRepository(DbContext));
        public RoleRepository RoleRepository => _RoleRepository ?? (_RoleRepository = new RoleRepository(DbContext));
        public BaseChargeRepository BaseChargeRepository => _BaseCharge ?? (_BaseCharge = new BaseChargeRepository(DbContext));
        public CommonJpLogCfgRepository CommonJpLogCfgRepository => _CommonJpLogCfgRepository ?? (_CommonJpLogCfgRepository = new CommonJpLogCfgRepository(DbContext));
        public CommonJpInventoryDetailRepository CommonJpInventoryDetailRepository => _CommonJpInventoryDetailRepository ?? (_CommonJpInventoryDetailRepository = new CommonJpInventoryDetailRepository(DbContext));
        public CommonJpInventoryTableRepository CommonJpInventoryTableRepository => _CommonJpInventoryTableRepository ?? (_CommonJpInventoryTableRepository = new CommonJpInventoryTableRepository(DbContext));
        public BaseJpWarehouseDevHistoryRepository BaseJpWarehouseDevHistoryRepository => _BaseJpWarehouseDevHistoryRepository ?? (_BaseJpWarehouseDevHistoryRepository = new BaseJpWarehouseDevHistoryRepository(DbContext));
        public InventoryReturnApplyDetailRepository InventoryReturnApplyDetailRepository => _InventoryReturnApplyDetailRepository ??= new InventoryReturnApplyDetailRepository(DbContext);
        public InventoryReturnApplyRepository InventoryReturnApplyRepository => _InventoryReturnApplyRepository ??= new InventoryReturnApplyRepository(DbContext);
        public EquipmentBoxMarkRepository EquipmentBoxMarkRepository => _EquipmentBoxMarkRepository ??= new EquipmentBoxMarkRepository(DbContext);
        public CommonJpPoliceShiftJobsApplyRepository CommonJpPoliceShiftJobsApplyRepository => _CommonJpPoliceShiftJobsApplyRepository ??= new CommonJpPoliceShiftJobsApplyRepository(DbContext);
        public CommonJpPoliceShiftJobsApplyDetailRepository CommonJpPoliceShiftJobsApplyDetailRepository => _CommonJpPoliceShiftJobsApplyDetailRepository ??= new CommonJpPoliceShiftJobsApplyDetailRepository(DbContext);
        public BaseJpTempFileRepository BaseJpTempFileRepository => _BaseJpTempFileRepository ??= new BaseJpTempFileRepository(DbContext);
        public BaseJpTempFileLogRepository BaseJpTempFileLogRepository => _BaseJpTempFileLogRepository ??= new BaseJpTempFileLogRepository(DbContext);

        #endregion

        #region 仓储操作（提交事务保存SaveChanges(),回滚RollBackChanges(),释放资源Dispose()）

        /// <summary>
        /// 保存
        /// </summary>
        public int SaveChanges()
        {

            return DbContext.SaveChanges();
        }
        public async Task<int> SaveChangesAsync()
        {
            return await DbContext.SaveChangesAsync();
        }
        /// <summary>
        /// 回滚
        /// </summary>
        public void RollBackChanges()
        {
            var items = DbContext.ChangeTracker.Entries().ToList();
            items.ForEach(o => o.State = EntityState.Unchanged);
        }
        /// <summary>
        /// 释放资源
        /// </summary>
        private bool disposed = false;
        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    DbContext.Dispose();//随着工作单元的销毁而销毁
                }
            }
            this.disposed = true;
        }
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        public IDbContextTransaction BeginTransaction()
        {
            var scope = DbContext.Database.BeginTransaction();
            return scope;
        }
        #endregion

    }
}
